<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Mail;
use App\Mail\SendMail;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class ContactoController extends Controller
{

    public function index(){

        return view('olimpoPortal.contactos');

    }


    public function contactoenvio(Request $request){

     //  die($request['email']);

     $this->validate($request,array(
        'nome' => 'required|min:3|max:255',
        'email' => 'required|email|max: 255',
        'contacto' => 'min:9|max:12',
        'mensagem' => 'min: 3',
        //'g-recaptcha-response' => 'required|recaptcha',
        'g-recaptcha-response' => function ($attribute, $value, $fail){
            $secretkey = config('services.recaptcha.secret');
           $response = $value;
            $userIP = $_SERVER['REMOTE_ADDR'];
            $url = "https://www.google.com/recaptcha/api/siteverify?secret=$secretkey&response=$response&remoteip=$userIP";
            $response = \file_get_contents($url);
            $response = json_decode($response);
            if(!$response->success){
               Session::flash('g-recaptcha-response','porfavor valida o reCaptcha');
                Session::flash('alert-class','alert-danger');
               $fail($attribute.' Falhou sua verificação.');

           }

        }
    ),[
        'nome.required' => 'O nome é de preenchimento obrigatório.',
        'nome.min' => 'O nome deve ter no mínimo 3 caracteres.',
        'email.email' => 'O email deve ser do tipo email válido.',
        'contacto.min' => 'O contacto deve ter no mínimo 9 caracteres.',
        'mensagem.min' => 'A Mensagem deve ter no mínimo 3 caracteres.',
        'g-recaptcha-response.recaptcha' => 'Verificação do Captcha falhou',
        'g-recaptcha-response.required' => 'Porfavor completar o recaptcha.'
]);

    //$validated=$this->rules($request);

     //dd($validated);
     $contacto = new ContactoForm($request);

     //$contacto = new ContactoForm($request);


    try {
        $contacto->sendMail();
        return back()
            ->with('success', 'Obrigado por nos contactar');
    } catch (\Exception $error) {
        return back()
            ->with('error', 'Ocorreu um erro Inesperado');
    }

    }

public function rules(array $data)
    {
        return Validator::make( $data,[
            'nome' => 'required|min:3|max:255',
            'email' => 'required|email|max: 255',
            'contacto' => 'min:9|max:12',
            'mensagem' => 'min: 3',
            //'g-recaptcha-response' => 'required|recaptcha',
            'g-recaptcha-response' => function ($attribute, $value, $fail){
                $secretkey = config('services.recaptcha.secret');
                $response = $value;
                $userIP = $_SERVER['REMOTE_ADDR'];
                $url = "https://www.google.com/recaptcha/api/siteverify?secret=$secretkey&response=$response&remoteip=$userIP";
                $response = \file_get_contents($url);
                $response = json_decode($response);
                if(!$response->success){
                    Session::flash('g-recaptcha-response','porfavor valida o reCaptcha');
                    Session::flash('alert-class','alert-danger');
                    $fail($attribute.' google recaptcha Falhou sua verificação.');

                }

            }

         ],[
            'nome.required' => 'O nome é de preenchimento obrigatório.',
            'nome.min' => 'O nome deve ter no mínimo 3 caracteres.',
            'email.email' => 'O email deve ser do tipo email válido.',
            'contacto.min' => 'O contacto deve ter no mínimo 9 caracteres.',
            'mensagem.min' => 'A Mensagem deve ter no mínimo 3 caracteres.',
            'g-recaptcha-response.recaptcha' => 'Verificação do Captcha falhou',
            'g-recaptcha-response.required' => 'Porfavor completar o recaptcha.'
   ]);
    }
public function messages()
    {
        return [
                'nome.required' => 'O nome é de preenchimento obrigatório.',
                'nome.min' => 'O nome deve ter no mínimo 3 caracteres.',
                'email.email' => 'O email deve ser do tipo email válido.',
                'contacto.min' => 'O contacto deve ter no mínimo 9 caracteres.',
                'mensagem.min' => 'A Mensagem deve ter no mínimo 3 caracteres.',
                'g-recaptcha-response.recaptcha' => 'Verificação do Captcha falhou',
                'g-recaptcha-response.required' => 'Porfavor completar o recaptcha.'
       ];
    }
}
