

<?php $__env->startSection('title', 'Membros - Membro'); ?>


<?php $__env->startSection('icone-modulo',"fa fa-building"); ?>
<?php $__env->startSection('titulopagina', 'Ngola Gestão De Membros'); ?>

<?php $__env->startSection('icone','fa fa-houzz'); ?>
<?php $__env->startSection('module','Membros/Membro'); ?>
<?php $__env->startSection('subtitle','Lista'); ?>



<?php $__env->startSection('content'); ?>

<?php if(session('mensagem')): ?>
<div class="alert alert-success alert-dismissible">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
    <?php echo e(session('mensagem')); ?>.
</div>
<?php endif; ?>

<!--**********************************
            Content body start
***********************************-->

<div class="row page-titles mx-0">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Ola, Bem-Vindo</h4>
            <span class="ml-1">Membro</span>
        </div>

    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Membros</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Membro</a></li>
        </ol>
    </div>
</div>
<!-- row -->

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Membros</h4>
                <!--<button type="button" class="btn btn-outline-dark" > Adicionar</button>-->
                <div class="btn-group">
                    <a title="" href="<?php echo e(route('membros.create')); ?>" class="btn btn-outline-dark"><i class="fa fa-plus-circle"></i> Adicionar</a>

                    <a  class="btn btn-default btn-sm" href="<?php echo e(route('membros.pdf')); ?>" target="_blank"><i class="fa fa-print"></i> Imprimir</a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="example" class="display" style="min-width: 845px">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Nome</th>
                                <th>Genero</th>
                                <th>Email</th>
                                <th>Estado Civil</th>
                                <th>Profissão</th>
                                <th>Salário</th>
                                <th style="text-align:center;">Operação</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $membro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->index +1); ?></td>

                                <td><?php echo e($membro->nome); ?></td>

                                <?php if($membro->genero=='M'): ?>
                                    <td>Masculino</td>
                                <?php elseif($membro->genero=='F'): ?>
                                    <td>Femenino</td>
                                <?php else: ?>
                                    <td>Outros</td>
                                <?php endif; ?>



                                <td><?php echo e($membro->email); ?></td>
                                <td>
                                <?php if($membro->estado_civil=='C'): ?>
                                    <small class="label  bg-green">Casado(a)</small>
                                <?php elseif($membro->estado_civil=='S'): ?>
                                    <small class="label  bg-green">Solteiro(a)</small>
                                <?php elseif($membro->estado_civil=='D'): ?>
                                    <small class="label  bg-green">Divorciado(a)</small>
                                <?php else: ?>
                                    <small class="label  bg-green">Viuvo(a)</small>
                                <?php endif; ?>
                            </td>
                                <td><?php echo e($membro->profissao); ?></td>

                                <td><?php echo e(number_format($membro->salario,2)); ?></td>


                                <td style="text-align:center;">

                                    <div class="btn-group">
                                            <a title="Ver" href="<?php echo e(route('membros.show',encrypt($membro->id))); ?>" class="btn btn-default btn-sm"><i class="fa fa-eye"></i></a>
                                    </div>

                                    <div class="btn-group">
                                        <a title="Editar" href="<?php echo e(route('membros.edit',encrypt($membro->id))); ?>" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></a>
                                    </div>
                                    <?php if(Auth::user()->role_id == 1 || Auth::user()->role_id == 2 ): ?>
                                        <div class="btn-group">
                                            <a title="Editar" href="<?php echo e(route('membros.suspencao',encrypt($membro->id))); ?>" class="btn btn-danger btn-sm"><i class="fa fa-user-times"></i></a>

                                        </div>
                                    <?php endif; ?>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
 window.setTimeout(function(){
	 $(".alert").fadeTo(500,0).slideUp(500, function(){
		 $(this).remove();
	 });
 }, 3000);
</script>
<?php $__env->stopSection(); ?>








<?php echo $__env->make('layouts.platform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /mnt/HC_Volume_101257152/proudmin/ngola.proudminds.co.ao/NgolaGestaoIgrejas/resources/views/membro/index.blade.php ENDPATH**/ ?>