<?php $__env->startSection('title', 'Eventos/Evento'); ?>

<?php $__env->startSection('icone-modulo',"fa fa-building"); ?>
<?php $__env->startSection('titulopagina', 'Gestão De Eventos'); ?>

<?php $__env->startSection('icone','fa fa-houzz'); ?>
<?php $__env->startSection('module','Eventos/Evento'); ?>

<?php if(isset($eventos)): ?>
<?php $__env->startSection('subtitle','Editar'); ?>
<?php else: ?>
<?php $__env->startSection('subtitle','Novo'); ?>
<?php endif; ?>


<?php $__env->startSection('content'); ?>


<div class="row page-titles mx-0">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Ola, Bem-Vindo!</h4>
            <span class="ml-1">Eventos</span>
        </div>
    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Eventos</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Evento</a></li>
        </ol>
    </div>
</div>

<div class="row">
    <div class="col-xl-6 col-xxl-12">



            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-houzz"></i> <?php if(isset($evento)): ?> Editar <?php else: ?> Registo de <?php endif; ?> Eventos/Evento</h3>
                </div>
                <!-- /.box-header -->
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Evento</h4>
                            </div>
                            <div class="card-body">
                                <?php if(isset($evento)): ?>
                                    <form  id="step-form-horizontal" class="step-form-horizontal" action="<?php echo e(route('eventos.update', encrypt($evento->id))); ?>" method="POST" enctype="multipart/form-data">
                                    <?php echo method_field('PUT'); ?>
                                <?php else: ?>
                                    <form  id="step-form-horizontal" class="step-form-horizontal" action="<?php echo e(route('eventos.store')); ?>" method="POST" enctype="multipart/form-data">

                                    <?php endif; ?>
                                    <?php echo csrf_field(); ?>

                                    <?php if($errors->any()): ?>
                                    <ul class="text-danger">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="text-danger"><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php endif; ?>
                                    <div>
                                        <h4>Evento Info</h4>
                                        <section>
                                            <div class="row">
                                                <div class="col-lg-6 mb-4">
                                                    <div class="form-group">
                                                        <label class="text-label">Titulo*</label>
                                                        <input type="text" name="titulo" value="<?php echo e($evento->titulo ?? ''); ?>"  maxlength="255" class="form-control"  required>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 mb-4">
                                                    <div class="form-group">
                                                        <label class="text-label">Oficiante / Pregador Principal*</label>
                                                        <input type="text" name="pastor" value="<?php echo e($evento->pastor ?? ''); ?>"  maxlength="255" class="form-control"  required>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 mb-4">
                                                    <div class="form-group">
                                                        <label class="text-label">Data Do Evento*</label>
                                                        <div class="input-group">
                                                            <input type="date" name="data_culto" value="<?php echo e($evento->data_culto ?? ''); ?>" class="form-control"    required>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-lg-6 mb-4">
                                                    <div class="form-group">
                                                        <label class="text-label">Tipo Evento*</label>
                                                        <div class="input-group">
                                                            <select class="form-control" name="tipos_eventos_id">
                                                                <option selected>Escolhe o tipo de evento</option>
                                                                <?php $__currentLoopData = $tiposeventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tiposeventos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($tiposeventos->id); ?>" >
                                                                  <?php echo e($tiposeventos->nome); ?>

                                                                </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </section>
                                        <h4>Igreja Info</h4>
                                        <section>
                                            <div class="row">
                                                <div class="col-lg-12 mb-4">
                                                    <div class="form-group">
                                                        <label class="text-label">Igreja*</label>
                                                        <select class="form-control" name="igreja_id">
                                                            <option selected>Escolhe a igreja</option>
                                                            <?php $__currentLoopData = $igrejas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $igreja): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($igreja->id); ?>" >
                                                              <?php echo e($igreja->nome); ?>

                                                            </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-lg-12 mb-4">
                                                    <div class="form-group">
                                                        <label class="text-label">Horario*</label>
                                                        <div class="input-group">
                                                            <input type="time" name="horario" value="<?php echo e($evento->horario ?? ''); ?>"class="form-control"  required>

                                                        </div>
                                                    </div>
                                                </div>


                                            </div>
                                        </section>
                                        <h4>Participação</h4>
                                        <section>
                                            <div class="row">
                                            <div class="col-lg-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-label">Quantidade Adulto *</label>
                                                    <div class="input-group">
                                                        <input name="qtd_adulto" value="<?php echo e($evento->qtd_adulto ?? ''); ?>"class="form-control" type="number" required>

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-label">Quantidade Criança *</label>
                                                    <div class="input-group">
                                                        <input name="qtd_crianca" value="<?php echo e($evento->qtd_crianca ?? ''); ?>"class="form-control" type="number" required>

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-label">Quantidade de Convertidos *</label>
                                                    <div class="input-group">
                                                        <input name="qtd_conversoes" value="<?php echo e($evento->qtd_conversoes ?? ''); ?>"class="form-control" type="number" required>

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-label">Quantidade de Visitas *</label>
                                                    <div class="input-group">
                                                        <input name="qtd_visita" value="<?php echo e($evento->qtd_visita ?? ''); ?>"class="form-control" type="number" required>

                                                    </div>
                                                </div>
                                            </div>


                                            <div class="col-lg-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-label">Quantidade de Batizados *</label>
                                                    <div class="input-group">
                                                        <input name="qtd_batizados" value="<?php echo e($evento->qtd_batizados ?? ''); ?>"class="form-control" type="number" >

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-label">Quantidade de Pregadores Presentes*</label>
                                                    <div class="input-group">
                                                        <input name="qtd_pastor_pres" value="<?php echo e($evento->qtd_pastor_pres ?? ''); ?>"class="form-control" type="number" required>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        </section>
                                        <h4>Valores</h4>
                                        <section>
                                            <div class="row">
                                            <div class="col-lg-6 mb-4">
                                                <div class="form-group">
                                                    <label for="currency-field" class="text-label">Total De Dizimo*</label>
                                                    <div class="input-group">
                                                        <input type="text" id="currency-field" pattern="^\$\d{1,3}(,\d{3})*(\.\d+)?$"  data-type="currency" placeholder="1,000,000.00" name="total_dizimo" value="<?php echo e($evento->total_dizimo ?? ''); ?>" class="form-control"   required>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-4">
                                                <div class="form-group">
                                                    <label for="currency-field" class="text-label">Total Arrecadado*</label>
                                                    <div class="input-group">
                                                        <input type="text" id="currency-field2" pattern="^\$\d{1,3}(,\d{3})*(\.\d+)?$"  data-type="currency" placeholder="1,000,000.00" name="total_arrecadado" value="<?php echo e($evento->total_arrecadado ?? ''); ?>" class="form-control"  required>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-4">
                                                <div class="form-group">
                                                    <label for="currency-field" class="text-label">Total de Ofertas Especiais*</label>
                                                    <div class="input-group">
                                                        <input type="text" id="currency-field3" pattern="^\$\d{1,3}(,\d{3})*(\.\d+)?$"  data-type="currency" placeholder="1,000,000.00" name="total_ofertas_esp" value="<?php echo e($evento->total_ofertas_esp ?? ''); ?>" class="form-control"  required>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-4">
                                                <div class="form-group">
                                                    <label class="text-label">Dizimista*</label>
                                                    <div class="input-group">
                                                        <input name="dizimista" value="<?php echo e($evento->dizimista ?? ''); ?>"class="form-control" type="text"required>

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-12 mb-4">
                                                <div class="form-group">
                                                    <label class="text-label">Outros*</label>
                                                    <div class="input-group">
                                                        <input name="outros" value="<?php echo e($evento->outros ?? ''); ?>"class="form-control" type="text" required>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        </section>
                                    </div>

                            </div>
                        </div>


            </div>


        </form>
    </div>
</div>



<?php $__env->stopSection(); ?>


<?php $__env->startSection('javascript'); ?>

<script src="<?php echo e(asset('assets/js/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/messages_pt_PT.min.js')); ?>"></script>

<script>









       errorPlacement:function($,t){
           $.addClass("help-block"),
           $.insertAfter(t)},
           highlight:function(t,n,a){$(t).parents(".form-group").addClass("has-error").removeClass("has-success")},
           unhighlight:function(t,n,a){$(t).parents(".form-group").addClass("has-success").removeClass("has-error")},



// Jquery Dependency

$("input[data-type='currency']").on({
    keyup: function() {
      formatCurrency($(this));
    },
    blur: function() {
      formatCurrency($(this), "blur");
    }
});


function formatNumber(n) {
  // format number 1000000 to 1,234,567
  return n.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",")
}


function formatCurrency(input, blur) {
  // appends $ to value, validates decimal side
  // and puts cursor back in right position.

  // get input value
  var input_val = input.val();

  // don't validate empty input
  if (input_val === "") { return; }

  // original length
  var original_len = input_val.length;

  // initial caret position
  var caret_pos = input.prop("selectionStart");

  // check for decimal
  if (input_val.indexOf(".") >= 0) {

    // get position of first decimal
    // this prevents multiple decimals from
    // being entered
    var decimal_pos = input_val.indexOf(".");

    // split number by decimal point
    var left_side = input_val.substring(0, decimal_pos);
    var right_side = input_val.substring(decimal_pos);

    // add commas to left side of number
    left_side = formatNumber(left_side);

    // validate right side
    right_side = formatNumber(right_side);

    // On blur make sure 2 numbers after decimal
    if (blur === "blur") {
      right_side += "00";
    }

    // Limit decimal to only 2 digits
    right_side = right_side.substring(0, 2);

    // join number by .
    input_val = "AO" + left_side + "." + right_side;

  } else {
    // no decimal entered
    // add commas to number
    // remove all non-digits
    input_val = formatNumber(input_val);
    input_val = "AO" + input_val;

    // final formatting
    if (blur === "blur") {
      input_val += ".00";
    }
  }

  // send updated string to input
  input.val(input_val);

  // put caret back in the right position
  var updated_len = input_val.length;
  caret_pos = updated_len - original_len + caret_pos;
  input[0].setSelectionRange(caret_pos, caret_pos);
}






</script>

<?php $__env->stopSection(); ?>








<?php echo $__env->make('layouts.platform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /mnt/HC_Volume_27524624/proudmin/ngola.proudminds.co.ao/NgolaGestaoIgrejas/resources/views/evento/create.blade.php ENDPATH**/ ?>