@extends('layouts.platform')

@section('title', 'Membros/Membro')

@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Gestão De Membros')

@section('icone','fa fa-houzz')
@section('module','Membros/Membro')
@section('subtitle','Ver')


@section('content')

<div class="row">

<div class="col-xl-6 col-xxl-12">

<div class="row page-titles mx-0">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Ola, Bem-Vindo!</h4>
            <span class="ml-1">Membros</span>
        </div>
    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Membros</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Membro</a></li>
        </ol>
    </div>
</div>



<form  id="entryForm" action="#" method="post" enctype="multipart/form-data">
<div class="box-header with-border">
    <h3 class="box-title"><i class="fa fa-houzz"></i> Dados da Membro</h3>

</div>

<div class="col-md-12">
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Membros</h4>
            <div class="btn-group">

                <a  class="btn btn-default btn-sm" href="{{ route('membro.pdf',encrypt($membro->id)) }}" target="_blank"><i class="fa fa-print"></i> Imprimir</a>
            </div>
        </div>
        <div class="card-body">
                        <div class="basic-form">
                                <div class="form-row">
                                    <div class="card-body">
                                    <!-- Nav tabs -->
                                    <ul class="nav nav-tabs" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link active" data-toggle="tab" href="#dadosPessoais">
                                                <span>
                                                    <i class="ti-user"></i>
                                                </span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#enderecoContacto">
                                                <span>
                                                    <i class="ti-email"></i>
                                                </span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#dadosProfissionais">
                                                <span>
                                                    <i class="ti-clipboard"></i>
                                                </span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#dadosIgreja">
                                                <span>
                                                    <i class="ti-home"></i>
                                                </span>
                                            </a>
                                        </li>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content tabcontent-border">
                                        <div class="tab-pane fade show active" id="dadosPessoais" role="tabpanel">
                                            <div class="pt-4">
                                                <h4>Dados Pessoais</h4>

                                                <div class="form-group col-md-12">
                                                    <label>Nome</label>
                                                    <input type="text" class="form-control" readonly value="{{ $membro->nome }}" maxlength="255">
                                                </div>
                                                <div class="form-group col-md-12">
                                                    <label>Nome do Pai</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $membro->nome_pai }}" maxlength="255" >
                                                </div>
                                                <div class="form-group col-md-12">
                                                    <label>Nome da Mãe</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $membro->nome_mae  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Contacto</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $membro->telefone  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Data De Nascimento</label>
                                                    <input type="text" class="form-control" readonly value="{{ $membro->data_nascimento }}"  maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Genero</label>
                                                    @if ($membro->genero=='M')
                                                        <input type="text" class="form-control" readonly  value="Masculino" >
                                                    @elseif ($membro->genero=='F')
                                                        <input type="text" class="form-control" readonly  value="Feminino" >
                                                    @else
                                                        <input type="text" class="form-control" readonly  value="Outros" >
                                                    @endif

                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Estado Civil</label>
                                                    @if ($membro->estado_civil=='C')
                                                        <input type="text" class="form-control" readonly  value="Casado(a)" maxlength="255">
                                                    @elseif ($membro->estado_civil=='S')
                                                        <input type="text" class="form-control" readonly  value="Solteiro(a)" maxlength="255">
                                                    @elseif ($membro->estado_civil=='D')
                                                        <input type="text" class="form-control" readonly  value="Divorciado(a)" maxlength="255">
                                                    @else
                                                        <input type="text" class="form-control" readonly  value="Viuvo(a)" maxlength="255">
                                                    @endif

                                                </div>

                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="enderecoContacto" role="tabpanel">
                                            <div class="pt-4">
                                                <h4>Endereço / Contacto</h4>

                                                <div class="form-group col-md-12">
                                                    <label>Contacto</label>
                                                    <input type="text" class="form-control"  readonly value="{{ $membro->telefone  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Pais</label>
                                                    <input type="text" class="form-control"  readonly  value="{{ $membro->municipio->provincia->pais->nome  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Provincia</label>
                                                    <input type="text" class="form-control"  readonly value="{{ $membro->municipio->provincia->nome  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Municipio</label>
                                                    <input type="text" class="form-control"  readonly value="{{ $membro->municipio->nome  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Email</label>
                                                    <input type="email" class="form-control"  readonly value="{{ $membro->email   }}" maxlength="255">
                                                </div>

                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="dadosProfissionais" role="tabpanel">
                                            <div class="pt-4">
                                                <h4>Dados Profissionais</h4>

                                                <div class="form-group col-md-12">
                                                    <label>Area De Formação</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $membro->area_formacao  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Profissao</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $membro->profissao  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Salario</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $membro->salario  }}" maxlength="255">
                                                </div>


                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="dadosIgreja" role="tabpanel">
                                            <div class="pt-4">
                                                <h4>Dados da Igreja</h4>

                                                <div class="form-group col-md-12">
                                                    <label>Igreja Onde é Batizada</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $membro->igreja_batizada  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>É Batizado Por Espirito Santo?</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $membro->batismo_esp_santo  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Data do Batismo</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $membro->data_batismo  }}" maxlength="255">
                                                </div>
                                                <div class="form-group col-md-12">
                                                    <label>Igreja Actual</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $membro->igreja->nome  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Documento Identificação</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $membro->doc_identificacao  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Estado</label>
                                                    @if ($membro->status == 1)
                                                        <input type="text" class="form-control" readonly  value="Activo" maxlength="255">
                                                    @else
                                                        <input type="text" class="form-control" readonly  value="Inactivo" maxlength="255">
                                                    @endif

                                                </div>

                                            </div>
                                        </div>
                                    </div>



                                        @error('valor')
                                            <span class="text-danger">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                        <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                                        <a href="{{ route('membros.edit',encrypt($membro->id)) }}" class="btn btn-info"><i class="fa fa-edit"></i> Editar</a>

                                </div>
                            </div>


            </div>

        </form>
    </div>
</div>







@endsection


@section('javascript')

<script src="{{ asset('assets/js/jquery.validate.min.js')}}"></script>
<script src="{{ asset('assets/js/messages_pt_PT.min.js')}}"></script>



<script>




</script>
@endsection







