@include('livewire.tipoEvento.create')
@include('livewire.tipoEvento.update')

@if (session()->has('message'))
     <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
          {!! session('message') !!}
     </div>
    @endif

<!--**********************************
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Tipos Eventos</span>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Configurações</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Utilizadores</a></li>
                        </ol>
                    </div>
                </div>
                <!-- row -->

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Tipos Eventos</h4>
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#createTipoEventoModal"><i class="fa fa-plus-circle"></i> Adicionar</button>

                            </div>

                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>
                                            {{ $prompt }}
                                            <tr>
                                                <th>#</th>
                                                <th>Nome</th>

                                                <th>Descricao</th>
                                                <th>Data de registo</th>
                                                <th>Data última actualização</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($v_tiposeventos as $tipoevento)
                                            <tr>
                                                <td>{{  $loop->index +1 }}</td>


                                                <td>{{  $tipoevento->nome }}</td>

                                                <td>{{  $tipoevento->descricao }}</td>

                                                <td>{{ \Carbon\Carbon::parse($tipoevento->created_at)->format('d/m/Y H:i:s') }}</td>
                                                <td>{{ \Carbon\Carbon::parse($tipoevento->updated_at)->format('d/m/Y H:i:s') }}</td>


                                                <td style="text-align: center;">

                                                        <button data-toggle="modal" data-target="#updateModal" wire:click="edit({{ $tipoevento->id }})" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></button>
                                                        <button wire:click="delete({{ $tipoevento->id }})" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>

                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>

                                    </table>
                                    {{ $v_tiposeventos->links() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>




