@extends('layouts.platform')

@section('title', 'Igrejas/Igreja')

@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Igrejas/Igreja')
@section('subtitle','Ver')


@section('content')

<div class="row">

<div class="col-xl-6 col-xxl-12">

<div class="row page-titles mx-0">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Ola, Bem-Vindo!</h4>
            <span class="ml-1">Igrejas</span>
        </div>
    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Igrejas</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Igreja</a></li>
        </ol>
    </div>
</div>



        <form  id="entryForm" action="#" method="post" enctype="multipart/form-data">
        <div class="box-header with-border">
            <h3 class="box-title"><i class="fa fa-houzz"></i> Dados da Igreja</h3>
        </div>

        <div class="box box-info">
        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Igreja</h4>
                            </div>
                            <div class="card-body">
                                <div class="basic-form">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Nome</label>
                                                <input type="text" class="form-control" readonly name="nome" value="{{ $igreja->nome }}"  maxlength="255" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Descrição</label>
                                                <input type="text" class="form-control" readonly name="descricao" value="{{ $igreja->descricao }}"  maxlength="255" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Razão Social</label>
                                                <input type="text" class="form-control" readonly name="razaoSocial" value="{{ $igreja->razaoSocial  }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Categoria</label>
                                                <input type="text" class="form-control" readonly name="categoria" value="{{ $igreja->categoria  }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Email</label>
                                                <input type="text" class="form-control" readonly name="email" value="{{ $igreja->email }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Endereço</label>
                                                <input type="text" class="form-control" readonly name="endereco" value="{{ $igreja->endereco   }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Contacto</label>
                                                <input type="text" class="form-control"  readonly name="telefone" value="{{ $igreja->telefone   }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Pais</label>
                                                <input type="text" class="form-control"  readonly name="pais" value="{{ $igreja->municipio->provincia->pais->nome  }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Provincia</label>
                                                <input type="text" class="form-control"  readonly name="provincia" value="{{ $igreja->municipio->provincia->nome  }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Municipio</label>
                                                <input type="text" class="form-control"  readonly name="municipio" value="{{ $igreja->municipio->nome  }}"  maxlength="255" required>
                                            </div>

                                            

                                          

                                           
                                           
                                           

                                            
                                            
                                        </div>
                                        @error('valor')
                                            <span class="text-danger">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                        <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                                        <a href="{{ route('igrejas.edit',$igreja->id) }}" class="btn btn-info"><i class="fa fa-edit"></i> Editar</a>

                                </div>
                            </div>
                        </div>      


            </div> 
            

        </form>
    </div>
</div>






@endsection


@section('javascript')

<script src="{{ asset('assets/js/jquery.validate.min.js')}}"></script>
<script src="{{ asset('assets/js/messages_pt_PT.min.js')}}"></script>



<script>




</script>
@endsection







