 <!-- Modal -->
<div  wire:ignore.self class="modal fade" tabindex="-1"    id="updateModal"   role="dialog" aria-labelledby="updateModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Tipo Bem Material</h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <form id="basic-form">

                    <div class="form-group row">
                        <label  class="col-sm-2 col-form-label">Nome<span class="text-danger">*</span></label>
                        <div class="col-sm-10">
                            <input wire:model.defer="nome" type="text" class="form-control"  placeholder="" value="" >
                            @error('nome') <span class="text-danger error">{{ $message }}</span>@enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label  class="col-sm-2 col-form-label">Descrição</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" value="" wire:model.defer="descricao">
                            @error('descricao') <span class="text-danger error">{{ $message }}</span>@enderror

                        </div>
                    </div>




                </form>
            </div>


            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" wire:click.prevent="update()" ><i class="fa fa-check"></i> Salvar</button>
            </div>
        </div>
    </div>
</div>

<script>

    $("#basic-form").validate({

        rules: {
               nome: {
                   required: true,
               },
               descricao: {
                   required: true,
                   min: 3,
               },


           },
                errorPlacement:function($,t){
                        $.addClass("help-block"),
                        $.insertAfter(t)},
                        highlight:function(t,n,a){$(t).parents(".form-group").addClass("has-error").removeClass("has-success")},
                        unhighlight:function(t,n,a){$(t).parents(".form-group").addClass("has-success").removeClass("has-error")},

        });
</script>
