<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Ngola - @yield('title') </title>

    @yield('styles')


    <!-- Google Fonts
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,700&subset=latin,cyrillic-ext" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" type="text/css">


	<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

-->



    @livewireStyles

    @yield('headscripts')


    <meta name="csrf-token" content="{{ csrf_token() }}">



</head>

<body>


        <section class="ftco-section">
            <div class="container">

                @yield('content')


            </div>
        </section>


        <!--**********************************
            Footer start
        ***********************************-->
        <div class="footer">
            <div class="copyright">
                <p>Copyright © Todos Direitos &amp; Reservados <a href="#" target="_blank">ProudMinds Consulting</a> <?php echo date('Y'); ?> </p>
                <p>Distributed by <a href="https://themewagon.com/" target="_blank">ProudMinds</a></p>
            </div>
        </div>
        <!--**********************************
            Footer end
        ***********************************-->

</div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


@livewireScripts(['base_url' => ENV('APP_URL')]);

    <!--**********************************
        Scripts
    ***********************************-->




    <!-- pdf init-->
    <script src="{{ asset('/platform/tabelasPdf/js/jquery.min.js') }}"></script>
    <script src="{{ asset('/platform/tabelasPdf/js/popper.js') }}"></script>
    <script src="{{ asset('/platform/tabelasPdf/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('/platform/tabelasPdf/js/main.js') }}"></script>








@yield('javascript')

</body>
</html>
