@extends('layouts.platform')

@section('title', 'Igrejas - Igreja')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Igrejas/Igreja')
@section('subtitle','Lista')



@section('content')

@if (session('mensagem'))
<div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                {{ session('mensagem') }}.
              </div>
@endif

<!--**********************************
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Igreja</span>
                        </div>

                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Igrejas</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Igreja</a></li>
                        </ol>


                    </div>
                </div>
                <!-- row -->

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Igrejas</h4>
                               <!--<button type="button" class="btn btn-outline-dark" > Adicionar</button>-->

                                    <a title="" href="{{ route('igrejas.create') }}" class="btn btn-outline-dark"><i class="fa fa-plus-circle"></i> Adicionar</a>

                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Nome</th>
                                                <th>Descricao</th>
                                                <th>Razão Social</th>
                                                <th>Categoria</th>
                                                <th>Email</th>
                                                <th>Endereço</th>
                                                <th>Telefone</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($data as $igreja)
                                            <tr>
                                                <td>{{  $loop->index +1 }}</td>

                                                <td>{{  $igreja->nome }}</td>

                                                <td>{{  $igreja->descricao }}</td>

                                                <td>{{  $igreja->razaoSocial }}</td>

                                                <td>{{  $igreja->categoria }}</td>

                                                <td>{{  $igreja->email }}</td>

                                                <td>{{  $igreja->endereco }}</td>

                                                <td>{{  $igreja->telefone }}</td>

                                                <td style="text-align:center;">

                                                    <div class="btn-group">
                                                            <a title="Ver" href="{{ route('igrejas.show',encrypt($igreja->id)) }}" class="btn btn-default btn-sm"><i class="fa fa-eye"></i></a>
                                                    </div>

                                                    <div class="btn-group">
                                                        <a title="Editar" href="{{ route('igrejas.edit',encrypt($igreja->id)) }}" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></a>
                                                    </div>

                                                    </td>

                                            </tr>
                                        @endforeach
                                        </tbody>

                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


@endsection

@section('javascript')
<script>
 window.setTimeout(function(){
	 $(".alert").fadeTo(500,0).slideUp(500, function(){
		 $(this).remove();
	 });
 }, 3000);
</script>
@endsection







