@extends('layouts.platform')

@section('title', 'Igrejas/Igreja')

@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Igrejas/Igreja')

@if(isset($igrejas))
@section('subtitle','Editar')
@else
@section('subtitle','Novo')
@endif


@section('content')


<div class="row page-titles mx-0">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Ola, Bem-Vindo!</h4>
            <span class="ml-1">Igrejas</span>
        </div>
    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Igrejas</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Igreja</a></li>
        </ol>
    </div>
</div>

<div class="row">
    <div class="col-xl-6 col-xxl-12">
            @if (isset($igreja))
                <form  id="entryForm" action="{{ route('igrejas.update', encrypt($igreja->id)) }}" method="POST" enctype="multipart/form-data">
                @method('PUT')
            @else
                <form  id="entryForm" action="{{ route('igrejas.store') }}" method="POST" enctype="multipart/form-data">

                @endif
                @csrf


            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-houzz"></i> @if(isset($igreja)) Editar @else Registo de @endif Igrejas/Igreja</h3>
                </div>
                <!-- /.box-header -->
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Igreja</h4>
                            </div>
                            <div class="card-body">
                                <div class="basic-form">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Nome</label>
                                                <input type="text" class="form-control"  name="nome" value="{{ $igreja->nome ?? '' }}"  maxlength="255" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Descrição</label>
                                                <input type="text" class="form-control"  name="descricao" value="{{ $igreja->descricao ?? '' }}"  maxlength="255" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Razão Social</label>
                                                <input type="text" class="form-control"  name="razaoSocial" value="{{ $igreja->razaoSocial ?? '' }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Categoria</label>
                                                <input type="text" class="form-control"  name="categoria" value="{{ $igreja->categoria ?? '' }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Email</label>
                                                <input type="text" class="form-control"  name="email" value="{{ $igreja->email ?? '' }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Endereço</label>
                                                <input type="text" class="form-control"  name="endereco" value="{{ $igreja->endereco ?? '' }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Contacto</label>
                                                <input type="text" class="form-control"  name="telefone" value="{{ $igreja->telefone ?? '' }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Pais</label>
                                                <select class="form-control" name="pais_id" id="country-dropdown">
                                                    <option selected>Escolhe...</option>
                                                    @foreach($pais as $pais)
                                                    <option value="{{ $pais->id }}" >
                                                      {{ $pais->nome }}
                                                    </option>
                                                    @endforeach

                                                </select>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Provincia</label>
                                                <select class="form-control" name="provincia_id" id="state-dropdown">


                                                </select>
                                            </div>


                                            <div class="form-group col-md-6">
                                                <label>Municipio</label>
                                                <select id="city-dropdown" class="form-control" name="municipio_id">

                                                </select>
                                            </div>




                                        </div>

                                        @if ($errors->any())
                                            <ul class="text-danger">
                                                @foreach ( $errors->all() as $error )
                                                    <li class="text-danger">{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        @endif

                                        @error('valor')
                                            <span class="text-danger">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                        <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                                        <button type="submit" class="btn btn-primary">Salvar</button>

                                </div>
                            </div>
                        </div>


            </div>


        </form>
    </div>
</div>



@endsection


@section('javascript')

<script src="{{ asset('assets/js/jquery.validate.min.js')}}"></script>
<script src="{{ asset('assets/js/messages_pt_PT.min.js')}}"></script>

<script>
    $(document).ready(function() {
    $('#country-dropdown').on('change', function() {
    var pais_id = this.value;
    $("#state-dropdown").html('');
    $.ajax({
    url:"{{url('get-states-by-country')}}",
    type: "POST",
    data: {
    pais_id: pais_id,
    _token: '{{csrf_token()}}'
    },
    dataType : 'json',
    success: function(result){
    $('#state-dropdown').html('<option value="">Escolhe a Provincia</option>');
    $.each(result.provincias,function(key,value){
    $("#state-dropdown").append('<option value="'+value.id+'">'+value.nome+'</option>');
    });
    $('#city-dropdown').html('<option value="">Escolhe Primeiro a Provincia</option>');
    }
    });
    });
    $('#state-dropdown').on('change', function() {
    var provincia_id = this.value;
    $("#city-dropdown").html('');
    $.ajax({
    url:"{{url('get-cities-by-state')}}",
    type: "POST",
    data: {
    provincia_id: provincia_id,
    _token: '{{csrf_token()}}'
    },
    dataType : 'json',
    success: function(result){
    $('#city-dropdown').html('<option value="">Escolhe o Municipio</option>');
    $.each(result.municipios,function(key,value){
    $("#city-dropdown").append('<option value="'+value.id+'">'+value.nome+'</option>');
    });
    }
    });
    });
    });

$("#entryForm").validate({

rules: {
       email: {
           required: true,
           email:true
       },
       nome: {
           required: true

       },
       descricao: {
           required: true

       },
       razaoSocial: {
           required: true

       },
       categoria: {
           required: true

       },
       endereco: {
           required: true

       },
       telefone: {
           required: true

       }

   },




       errorPlacement:function($,t){
           $.addClass("help-block"),
           $.insertAfter(t)},
           highlight:function(t,n,a){$(t).parents(".form-group").addClass("has-error").removeClass("has-success")},
           unhighlight:function(t,n,a){$(t).parents(".form-group").addClass("has-success").removeClass("has-error")},



});

</script>

@endsection







