@extends('layouts.platformPdf')

@section('title', 'Saidas -  PDF')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Saidas/PDF')
@section('subtitle','PDF')



@section('content')

<div hidden>
    @php
     $totalValor=0;
    @endphp
</div>
			<div class="row justify-content-center">
				<div class="col-md-6 text-center mb-5">
					<h2 style="text-align: center ; margin-bottom: 100px; margin-top: 50px;">Lista Geral De Saidas</h2>
				</div>
			</div>
			<div class="row">
				<div class="col-md-12">

                    <table class="principal" >
                        <thead >
                          <tr class="cabeca">
                                <th width="5%" style="text-align: center;">#</th>
                                <th style="text-align: left;">Tipo Saida</th>
                                <th style="text-align: center;">Descrição</th>
                                <th style="text-align: center;">Forma Pagamento</th>
                                <th style="text-align: center;">Valor</th>
                                <th style="text-align: center;">Data Recebido a Saida</th>


						    </tr>
						  </thead>
						  <tbody>
                            @foreach ($data as $saida)
                                <tr >
                                <td>{{  $loop->index +1 }}</td>
                                <td>{{  $saida->tipos_saidas->nome }}</td>
                                <td>{{  $saida->descricao }}</td>
                                <td>{{  $saida->formas_pagamentos->nome }}</td>
                                <td>{{  number_format($saida->valor,2)  }}</td>
                                <td>{{ \Carbon\Carbon::parse($saida->data_saidas)->format('d/m/Y H:i:s') }}</td>


                                @php
                                    $totalValor += $saida->valor
                                @endphp

                                </tr>

                            @endforeach
						  </tbody>
						</table>



                <div class="col-md-6 text-center mb-5">
                    <h1 style="
                    width: 100%;bottom: 0;
                     margin-left:  120px;" class="heading-section">Total do Valor de Saidas: {{  number_format($totalValor,2)  }} </h1>
                </div>
			</div>
		</div>
    </div>

    <script type="text/php">

        if ( isset($pdf) ) {

            $font = $fontMetrics->get_font("helvetica", "bold");

            $pdf->page_text(1070, 800, "Página: {PAGE_NUM} de {PAGE_COUNT}", $font, 10,  array(0,0,0));


        }

    </script>


        <footer style="
        width: 100%;
        position: fixed;
        bottom: 0;
        left: 0;">


<hr>

<div style="float: left; font-family: Arial Narrow, sans-serif "">|<small> Ngola Gestão de Igrejas</small> </div>

<div style="margin-left:  850px; font-family: Arial Narrow, sans-serif "><small>  Utilizador : {{ Auth::user()->name }} ,  &nbsp; {{date('d-m-Y')}} - Processado por compudador </small></div>



</footer>
@endsection
