@extends('layouts.platformPdf')

@section('title', 'Membros - Membros PDF')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Membros/PDF')
@section('subtitle','Lista')



@section('content')



			<div class="row justify-content-center">
				<div class="col-md-6 text-center mb-5">
					<h2 style="text-align: center ; margin-bottom: 100px; margin-top: 50px;" >Lista Geral De Membros</h2>
				</div>
			</div>
			<div class="row">
				<div class="col-md-12">

						<table class="principal" >
						  <thead >
						    <tr class="cabeca">
                                <th width="5%" style="text-align: center;">#</th>
                                <th style="text-align: center;">Nome Completo</th>
                                <th width="75" style="text-align: left;">Nome Pai</th>
                                <th width="75" style="text-align: left;">Nome Mãe</th>
                                <th width="50" style="text-align: left;">Contacto</th>
                                <th width="70" style="text-align: center;">Data Nascimento</th>
                                <th width="50" style="text-align: left;">Genero</th>
                                <th width="50" style="text-align: center;">Email</th>
                                <th width="75" style="text-align: left;">Estado Civil</th>
                                <th width="80" style="text-align: left;">Igreja Actual</th>
                                <th width="70" style="text-align: center;">Data Batismo</th>
                                <th width="50" style="text-align: center;">Profissão</th>
                                <th width="50" style="text-align: left;">Salário</th>
                                <th width="50" style="text-align: left;">Estado</th>
						    </tr>
						  </thead>
						  <tbody>
                            @foreach ($data as $membro)
                                <tr  >
                                <td >{{  $loop->index +1 }}</td>
                                <td>{{  $membro->nome }}</td>

                                <td>{{  $membro->nome_pai }}</td>
                                <td>{{  $membro->nome_mae }}</td>
                                <td>{{  $membro->telefone }}</td>
                                <td>{{  $membro->data_nascimento }}</td>

                                @if($membro->genero=='M')
                                    <td>Masculino</td>
                                @elseif($membro->genero=='F')
                                    <td>Femenino</td>
                                @else
                                    <td>Outros</td>
                                @endif



                                <td>{{  $membro->email }}</td>
                                <td>
                                @if($membro->estado_civil=='C')
                                    <small >Casado(a)</small>
                                @elseif ($membro->estado_civil=='S')
                                    <small >Solteiro(a)</small>
                                @elseif ($membro->estado_civil=='D')
                                    <small >Divorciado(a)</small>
                                @else
                                    <small >Viuvo(a)</small>
                                @endif
                            </td>

                                <td>{{  $membro->igreja->nome }}</td>
                                <td>{{  $membro->data_batismo }}</td>

                                <td>{{  $membro->profissao }}</td>

                                <td>{{  $membro->salario }}</td>

                                @if ($membro->status == 1)
                                    <td>Activo</td>
                                @else
                                    <td>Inactivo</td>
                                @endif

                                </td>
                                </tr>

                            @endforeach
						  </tbody>
						</table>

				</div>
			</div>

            <script type="text/php">

                if ( isset($pdf) ) {

                    $font = $fontMetrics->get_font("helvetica", "bold");

                    $pdf->page_text(1070, 800, "Página: {PAGE_NUM} de {PAGE_COUNT}", $font, 10,  array(0,0,0));


                }

            </script>

            <footer style="
            width: 100%;
            position: fixed;
            bottom: 0;
            left: 0;">


    <hr>

    <div style="float: left; font-family: Arial Narrow, sans-serif  ">|<small> Ngola Gestão de Igrejas</small> </div>

    <div style="margin-left:  850px; font-family: Arial Narrow, sans-serif "><small>  Utilizador : {{ Auth::user()->name }} ,  &nbsp; {{date('d-m-Y')}} - Processado por compudador </small></div>



  </footer>
@endsection


