@extends('layouts.platform')

@section('title', 'Eventos/Evento')

@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Gestão De Eventos')

@section('icone','fa fa-houzz')
@section('module','Eventos/Evento')
@section('subtitle','Ver')


@section('content')

<div class="row">

<div class="col-xl-6 col-xxl-12">

<div class="row page-titles mx-0">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Ola, Bem-Vindo!</h4>
            <span class="ml-1">Eventos</span>
        </div>
    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Eventos</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Evento</a></li>
        </ol>
    </div>
</div>



<form  id="entryForm" action="#" method="post" enctype="multipart/form-data">
<div class="box-header with-border">
    <h3 class="box-title"><i class="fa fa-houzz"></i> Dados da Evento</h3>
</div>

<div class="col-md-12">
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Eventos</h4>
            <div class="btn-group">

                <a  class="btn btn-default btn-sm" href="{{ route('evento.pdf',encrypt($evento->id)) }}" target="_blank"><i class="fa fa-print"></i> Imprimir</a>
            </div>
        </div>

        <div class="card-body">
                        <div class="basic-form">
                                <div class="form-row">
                                    <div class="card-body">
                                    <!-- Nav tabs -->
                                    <ul class="nav nav-tabs" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link active" data-toggle="tab" href="#eventoInfo">
                                                <span>
                                                    <i class="ti-user"></i>
                                                </span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#igrejaInfo">
                                                <span>
                                                    <i class="ti-email"></i>
                                                </span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#participacao">
                                                <span>
                                                    <i class="ti-clipboard"></i>
                                                </span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#valor">
                                                <span>
                                                    <i class="ti-home"></i>
                                                </span>
                                            </a>
                                        </li>

                                    </ul>

                                    <!-- Tab panes -->
                                    <div class="tab-content tabcontent-border">
                                        <div class="tab-pane fade show active" id="eventoInfo" role="tabpanel">
                                            <div class="pt-4">
                                                <h4>Informações sobre o Evento</h4>

                                                <div class="form-group col-md-12">
                                                    <label>Titulo</label>
                                                    <input type="text" class="form-control" readonly value="{{ $evento->titulo }}" maxlength="255">
                                                </div>
                                                <div class="form-group col-md-12">
                                                    <label>Oficiante / Pregador</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->pastor }}" maxlength="255" >
                                                </div>
                                                <div class="form-group col-md-12">
                                                    <label>Data do Culto</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->data_culto  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Horario</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->horario  }}" maxlength="255">
                                                </div>


                                                <div class="form-group col-md-12">
                                                    <label>Tipo de Evento </label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->tipos_eventos->nome  }}" maxlength="255">
                                                </div>


                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="igrejaInfo" role="tabpanel">
                                            <div class="pt-4">
                                                <h4>Informações sobre a Igreja</h4>

                                                <div class="form-group col-md-12">
                                                    <label>Igreja </label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->igreja->nome  }}" maxlength="255">
                                                </div>


                                                <div class="form-group col-md-12">
                                                    <label>Igreja Actual</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->igreja->descricao  }}" maxlength="255">
                                                </div>


                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="participacao" role="tabpanel">
                                            <div class="pt-4">
                                                <h4>Dados sobre a Participação</h4>

                                                <div class="form-group col-md-12">
                                                    <label>Quantidade de Adultos</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->qtd_adulto  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Quantidade de Crianças</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->qtd_crianca  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Quantidade de Conversões</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->qtd_conversoes  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Quantidade de Batizados</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->qtd_batizados  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Quantidade de Visitas</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->qtd_visita  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Quantidade total de Participantes</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->qtd_total_part  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Quantidade total de Pregadores Presentes</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->qtd_pastor_pres  }}" maxlength="255">
                                                </div>





                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="valor" role="tabpanel">
                                            <div class="pt-4">
                                                <h4>Dados sobre Valores</h4>

                                                <div class="form-group col-md-12">
                                                    <label>Valor Total de Dizimo</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->total_dizimo  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Valor Total de Ofertas Especiais</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->total_ofertas_gerais  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Valor Total Arrecadado</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->total_arrecadado  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Dizimista</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->dizimista  }}" maxlength="255">
                                                </div>

                                                <div class="form-group col-md-12">
                                                    <label>Outros</label>

                                                        <input type="text" class="form-control" readonly  value="{{ $evento->outros  }}" maxlength="255">


                                                </div>
                                                <div class="form-group col-md-12">
                                                    <label>Valor Total De Ofertas</label>
                                                    <input type="text" class="form-control" readonly  value="{{ $evento->total_ofertas_gerais  }}" maxlength="255">
                                                </div>

                                            </div>
                                        </div>
                                    </div>



                                        @error('valor')
                                            <span class="text-danger">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                        <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                                        <a href="{{ route('eventos.edit',encrypt($evento->id)) }}" class="btn btn-info"><i class="fa fa-edit"></i> Editar</a>

                                </div>
                            </div>


            </div>

        </form>
    </div>
</div>







@endsection


@section('javascript')

<script src="{{ asset('assets/js/jquery.validate.min.js')}}"></script>
<script src="{{ asset('assets/js/messages_pt_PT.min.js')}}"></script>



<script>




</script>
@endsection







