@extends('layouts.platform')

@section('title', 'Tesouraria - Entrada')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Tesouraria / Entrada')

@if(isset($entradas))
@section('subtitle','Editar')
@else
@section('subtitle','Novo')
@endif



@section('content')
<div class="card">
    <div class="card-header">
        <h4 class="card-title">Registo De Entradas</h4>
    </div>
    <div class="card-body">
        <div class="basic-form">

            @if (isset($entrada))
            <form  id="basic-form" action="{{ route('entradas.update', encrypt($entrada->id)) }}" method="POST" enctype="multipart/form-data">
            @method('PUT')
            @else
            <form  id="basic-form" action="{{ route('entradas.store') }}" method="POST" enctype="multipart/form-data">

            @endif
            @csrf
            @if ($errors->any())
            <ul class="text-danger">
                @foreach ( $errors->all() as $error )
                    <li class="text-danger">{{ $error }}</li>
                @endforeach
            </ul>
            @endif
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label class="text-label">Tipo De Entrada*</label>
                        <div class="input-group">
                            <select class="form-control" name="tipos_entradas_id" >
                                <option selected>Escolhe...</option>
                                @foreach($tiposentradas as $tipoentrada)
                                    <option value="{{ $tipoentrada->id }}" > {{ $tipoentrada->nome }}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Forma De Entrada*</label>
                        <div class="input-group">
                            <select class="form-control" name="formas_pagamentos_id" >
                                <option selected>Escolhe...</option>
                                @foreach($formaspagamentos as $formapagamento)
                                    <option value="{{ $formapagamento->id }}" > {{ $formapagamento->nome }}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Data Recebido*</label>
                        <div class="input-group">
                            <input type="date" name="data_entrada" value="{{ $entrada->data_entrada ?? '' }}" class="form-control"    required>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Descrição*</label>
                        <div class="input-group">
                            <input type="text" name="descricao" value="{{ $entrada->descricao ?? '' }}" class="form-control"    required>
                        </div>
                    </div>


                <div class="form-group col-md-6">
                    <label class="text-label">Valor*</label>
                <div class="input-group mb-6">

                    <div class="input-group-prepend">
                        <span class="input-group-text">$</span>
                    </div>
                    <input type="number" name="valor" id="valor" class="form-control" value="{{ $entrada->valor ?? '' }}">
                    <div class="input-group-append">
                        <span class="input-group-text">00</span>
                    </div>
                </div>
            </div>
                <div class="form-group col-md-6">
                    <label class="text-label">Membro*</label>
                    <div class="input-group">
                        <select class="form-control" name="membros_id" >
                            <option selected>Escolhe...</option>
                            @foreach($membros as $membro)
                                <option value="{{ $membro->id }}" > {{ $membro->nome }}</option>
                            @endforeach

                        </select>
                    </div>
                </div>
            </div>

            <div class="box">
                <div class="box-footer">
                    <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                    <button type="submit" class="btn btn-info pull-right"><i class="fa fa-check-circle"></i> Salvar</button>
                </div>
            </div>
        </div>
    </div>
</div>
</form>
@endsection


@section('javascript')
<script src="{{ asset('platform/js/formatarValorMonetario.js') }}" type="text/javascript"></script>
<script>

$("#basic-form").validate({

    rules: {
           tipos_entradas_id: {
               required: true,
           },
           valor: {
               required: true,
           },
           descricao: {
               required: true,
               min: 3,
           },


       },
		    errorPlacement:function($,t){
				    $.addClass("help-block"),
					$.insertAfter(t)},
					highlight:function(t,n,a){$(t).parents(".form-group").addClass("has-error").removeClass("has-success")},
					unhighlight:function(t,n,a){$(t).parents(".form-group").addClass("has-success").removeClass("has-error")},

    });
    </script>
     <script type="text/javascript">



         function validaDouble(campo, evento, valor) {
                    var tecla = (window.evento) ? evento.keyCode : evento.which;

                    //campo.value = campo.value.replace(/,/gi, ".");

                    if (tecla === 13) {
                        return false;
                    }
                    else {
                        if (tecla === 8 || tecla === 0 || tecla === 45) {
                            return true;
                        }
                        else {
                            valor += "" + tecla - 48;
                            if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57) {
                                return false;
                            }
                        }
                    }
                }

        function validaNumeroS(evento, valor) {
            var tecla = (window.evento) ? evento.keyCode : evento.which;
            if ((tecla === 13) || (tecla === 44) || (tecla === 45) || (tecla === 46)) {
                return false;
            }
            else {
                if (tecla === 8 || tecla === 0 || tecla === 45) {
                    return true;
                }
                else {
                    valor += "" + tecla - 48;
                    if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57) {
                        return false;
                    }
                }
            }
        }

        function validaS(campo, evento, valor) {
                    var tecla = (window.evento) ? evento.keyCode : evento.which;



                    if (tecla === 13) {
                        return false;
                    }
                    else {
                        if (tecla === 8 || tecla === 0 || tecla === 45) {
                            return true;
                        }
                        else {
                            valor += "" + tecla - 48;
                            if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57 || valor < 0) {
                                return false;
                            }
                        }
                    }
                }
</script>

<script>
    //document.getElementById("valor").onblur = function () {
        //this.value = formatarValorMonetario(this.value)

     //   this.value = new Intl.NumberFormat().format(this.value)
    //}

    new Intl.NumberFormat('en-DE').format("valor")

</script>
@endsection
