@extends('layouts.platform')

@section('title', 'Configurações - Pais')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Configurações/Pais')
@section('subtitle','Lista')



@section('content')

@if (session('mensagem'))
<div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                {{ session('mensagem') }}.
              </div>
@endif

<!--**********************************
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Pais</span>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Configurações</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Pais</a></li>
                        </ol>
                    </div>
                </div>
                <!-- row -->

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Pais</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Iso</th>
                                                <th>Nome</th>
                                                <th>Nacionalidade</th>
                                                <th>Num Code</th>
                                                <th>Idicativo</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($data as $pais)
                                            <tr>
                                                <td>{{  $loop->index +1 }}</td>

                                                <td>{{  $pais->iso }}</td>

                                                <td>{{  $pais->nome }}</td>

                                                <td>{{  $pais->nacionalidade }}</td>

                                                <td>{{  $pais->numCode }}</td>

                                                <td>{{  $pais->indicativo }}</td>

                                                <td style="text-align:center;">

                                                    <div class="btn-group">
                                                            <a title="Ver" href="{{ route('pais.show',encrypt($pais->id)) }}" class="btn btn-default btn-sm"><i class="fa fa-eye"></i></a>
                                                    </div>

                                                    <div class="btn-group">
                                                        <a title="Editar" href="{{ route('pais.edit',encrypt($pais->id)) }}" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></a>
                                                    </div>

                                                    </td>

                                            </tr>
                                        @endforeach
                                        </tbody>

                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


@endsection

@section('javascript')
<script>
 window.setTimeout(function(){
	 $(".alert").fadeTo(500,0).slideUp(500, function(){
		 $(this).remove();
	 });
 }, 3000);
</script>
@endsection







