@extends('layouts.platform')

@section('title', 'Tesouraria - Caixa')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Tesouraria / Caixa')
@section('subtitle','Lista')



@section('content')


    @if (session()->has('message'))
     <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
          {!! session('message') !!}
     </div>
    @endif

<!--**********************************
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Caixa</span>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Tesouraria</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Caixas</a></li>
                        </ol>
                    </div>
                </div>
                <!-- row -->

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header" style="text-align: right;">

                                <h4 class="card-title">caixa</h4>
                                <div class="btn-group">
                                    <a title="" href="{{ route('caixas.create') }}" class="btn btn-outline-dark"><i class="fa fa-plus-circle"></i> Adicionar</a>


                                </div>


                            </div>

                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>

                                            <tr>
                                                <th>#</th>
                                                <th>Estado</th>
                                                <th>Saldo Anterior</th>
                                                <th>Saldo Actual</th>

                                                <th>Data Criação</th>
                                                <th>Data última actualização</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($caixas as $caixa)
                                            <tr>
                                                <td>{{  $loop->index +1 }}</td>
                                                @if($caixa->status==1)
                                                    <td><small class="label  bg-green">Activo</small></td>
                                                @else
                                                    <td> <small class="label  bg-red">Inactivo</small></td>
                                                @endif
                                                <td>{{  number_format($caixa->saldoAnt,2)  }}</td>
                                                <td>{{  number_format($caixa->saldoActual,2)  }}</td>

                                                <td>{{ \Carbon\Carbon::parse($caixa->created_at)->format('d/m/Y H:i:s') }}</td>

                                                <td>{{ \Carbon\Carbon::parse($caixa->updated_at)->format('d/m/Y H:i:s') }}</td>


                                                <td style="text-align:center;">

                                                    <div class="btn-group">
                                                            <a title="Ver" href="{{ route('caixas.show',encrypt($caixa->id)) }}" class="btn btn-default btn-sm"><i class="fa fa-eye"></i></a>
                                                    </div>

                                                    <div class="btn-group">
                                                        @if(Auth::user()->role_id == 1 )
                                                        <a title="Editar" href="{{ route('caixas.edit',encrypt($caixa->id)) }}" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></a>
                                                        @endif
                                                    </div>

                                                </td>

                                            </tr>
                                            @endforeach
                                        </tbody>

                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>


@endsection


@section('javascript')

@endsection
