@extends('layouts.platform')

@section('title', 'Equipamentos / Activos')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Equipamentos / Activos')
@section('subtitle','Ver')



@section('content')

<div class="card">
    <div class="card-header">
        <h4 class="card-title">Visualização De Equipamentos Activos</h4>
    </div>
    <div class="card-body">
        <div class="basic-form">

            @if (isset($bemmaterial))
            <form  id="basic-form" action="{{ route('bensmateriais.update', $bemmaterial->id) }}" method="POST" enctype="multipart/form-data">
            @method('PUT')
            @else
            <form  id="basic-form" action="{{ route('bensmateriais.store') }}" method="POST" enctype="multipart/form-data">

            @endif
            @csrf
            @if ($errors->any())
            <ul class="text-danger">
                @foreach ( $errors->all() as $error )
                    <li class="text-danger">{{ $error }}</li>
                @endforeach
            </ul>
            @endif
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label class="text-label">Tipo De Bens Materiais*</label>
                        <div class="input-group">
                            <input type="text" name="tipos_bens_materiais" value="{{ $bemmaterial->tipos_bens_materiais->nome  }}" class="form-control"    readonly>


                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Forma De Aquisição do Bem*</label>
                        <div class="input-group">
                            <input type="text" name="formas_aquissicao_bens" value="{{ $bemmaterial->formas_aquisicao_bens->nome  }}" class="form-control"    readonly>

                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Data do Bem*</label>
                        <div class="input-group">
                            <input type="date" name="data" value="{{ $bemmaterial->data ?? '' }}" class="form-control"    readonly>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Referência*</label>
                        <div class="input-group">
                            <input type="text" name="referencia" value="{{ $bemmaterial->referencia ?? '' }}" class="form-control"    readonly>
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <label class="text-label">Estado*</label>
                        <div class="input-group">
                            <input type="text" name="estado" value="{{ $bemmaterial->estado ?? '' }}" class="form-control"    readonly>
                        </div>
                    </div>
                     <div class="form-group col-md-6">
                        <label class="text-label">Nome Do Bem*</label>
                        <div class="input-group">
                            <input type="text" name="nome" value="{{ $bemmaterial->nome ?? '' }}" class="form-control"    readonly>
                        </div>
                    </div>

                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text">$</span>
                    </div>
                    <input type="number" class="form-control" value="{{ $bemmaterial->valor ?? '' }}" readonly>
                    <div class="input-group-append">
                        <span class="input-group-text">00</span>
                    </div>
                </div>



            </form>
            <div class="box">
                <div class="box-footer">
                    <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                    @if(Auth::user()->id == 1 )
                        <a href="{{ route('bensmateriais.edit',encrypt($bemmaterial->id)) }}" class="btn btn-info"><i class="fa fa-edit"></i> Editar</a>
                    @endif
                    <a  class="btn btn-default btn-sm" href="{{ route('bensmateriais.pdf',encrypt($bemmaterial->id)) }}" target="_blank"><i class="fa fa-print"></i> Imprimir</a>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection


@section('javascript')

@endsection
