
@extends('layouts.platform')

@section('title', 'Equipamentos - Entrada')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Equipamentos / Entrada')
@section('subtitle','Lista')




@section('content')
@include('bemMaterial.depreciacao')

    @if (session()->has('message'))
     <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
          {!! session('message') !!}
     </div>
    @endif

<!--**********************************
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Equipamentos Activos</span>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Equipamentos / Activos</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Bens Materiais</a></li>
                        </ol>
                    </div>
                </div>
                <!-- row -->

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header" style="text-align: right;">

                                <h4 class="card-title">Bens Materiais</h4>
                                <div class="btn-group">
                                    <a title="" href="{{ route('bensmateriais.create') }}" class="btn btn-outline-dark"><i class="fa fa-plus-circle"></i> Adicionar</a>

                                    <a  class="btn btn-default btn-sm" href="#"  > </a>
                                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#depreciarBemMaterial"><i class="fa fa-times"></i> Depreciar</button>

                                    <a  class="btn btn-default btn-sm" href="{{ route('bensmateriais.pdf') }}" target="_blank"><i class="fa fa-print"></i> Imprimir</a>
                                </div>


                            </div>

                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>

                                            <tr>
                                                <th>#</th>
                                                <th>Referência</th>
                                                <th>Nome do Bem</th>
                                                <th>Tipo Bem Material</th>
                                                <th>Forma de Aquicição</th>
                                                <th>Estado</th>
                                                <th>Data do Bem</th>
                                                <th>Data última actualização</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($bensmateriais as $bemmaterial)
                                            <tr>
                                                <td>{{  $loop->index +1 }}</td>

                                                <td>{{  $bemmaterial->referencia }}</td>
                                                <td>{{  $bemmaterial->nome }}</td>
                                                <td>{{  $bemmaterial->tipos_bens_materiais->nome }}</td>
                                                <td>{{  $bemmaterial->formas_aquisicao_bens->nome }}</td>

                                                @if ($bemmaterial->estado == 'A')
                                                    <td>Activo</td>
                                                @else
                                                    <td>Depreciado</td>
                                                @endif


                                                <td>{{ \Carbon\Carbon::parse($bemmaterial->data)->format('d/m/Y H:i:s') }}</td>

                                                <td>{{ \Carbon\Carbon::parse($bemmaterial->updated_at)->format('d/m/Y H:i:s') }}</td>


                                                <td style="text-align:center;">

                                                    <div class="btn-group">
                                                            <a title="Ver" href="{{ route('bensmateriais.show',encrypt($bemmaterial->id)) }}" class="btn btn-default btn-sm"><i class="fa fa-eye"></i></a>
                                                    </div>

                                                    <div class="btn-group">
                                                        @if(Auth::user()->role_id == 1 )
                                                            <a title="Editar" href="{{ route('bensmateriais.edit',encrypt($bemmaterial->id)) }}" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></a>
                                                        @endif
                                                    </div>

                                                </td>

                                            </tr>
                                            @endforeach
                                        </tbody>

                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>


@endsection


@section('javascript')

@endsection
