 <!-- Modal -->
 <div  wire:ignore.self class="modal fade" tabindex="-1"    id="depreciarBemMaterial"   >
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Depreciar / Dar Baixa Ao Bem Material</h5>
                <button type="button" class="close" data-dismiss="modal" wire:click.prevent="limpaCampos()"><span>&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <form id="basic-form"  action="{{ route('depreciacao.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label">Bem Material<span class="text-danger">*</span></label>
                        <div class="col-sm-10">
                            <select wire:model.defer="bens_materiais_id" name="bens_materiais_id" class="form-control" >

                                @foreach($bensmateriais as $bemMaterial)
                                    <option value="{{ $bemMaterial->id }}">{{ $bemMaterial->nome }}</option>
                                @endforeach

                            </select>
                        </div>
                        @error('bens_materiais_id') <span class="text-danger error">{{ $message }}</span>@enderror
                    </div>

                    <div class="form-group row">
                        <label  class="col-sm-2 col-form-label">Motivo<span class="text-danger">*</span></label>
                        <div class="col-sm-10">
                            <select wire:model.defer="motivo" name="motivo" class="form-control" >
                                <option value="Mal Estado De Conservação">Mal Estado De Conservação</option>
                                <option value="Danificado">Danificado</option>
                                <option value="Fim Tempo de Vida">Fim Tempo de Vida</option>
                                <option value="Outro">Outro</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label  class="col-sm-2 col-form-label">Data Depreciação</label>
                        <div class="col-sm-10">
                            <input type="date" name="data_depreciacao" class="form-control" wire:model.defer="data_depreciacao" >
                            @error('data_depreciacao') <span class="text-danger error">{{ $message }}</span>@enderror

                        </div>
                    </div>

                    @if ($errors->any())
                    <ul class="text-danger">
                        @foreach ( $errors->all() as $error )
                            <li class="text-danger">{{ $error }}</li>
                        @endforeach
                    </ul>
                @endif

                <div class="modal-footer">
                    <button type="button" class="btn btn-default close-btn" data-dismiss="modal"> Cancelar</button>

                    <button type="submit" class="btn btn-info close-modal" ><i class="fa fa-check"></i> Salvar</button>
                </div>


                </form>
            </div>



        </div>
    </div>
</div>

<script>

    $("#basic-form").validate({

        rules: {
               motivo: {
                   required: true,
               },
               data_depreciacao: {
                   required: true,

               },


           },
                errorPlacement:function($,t){
                        $.addClass("help-block"),
                        $.insertAfter(t)},
                        highlight:function(t,n,a){$(t).parents(".form-group").addClass("has-error").removeClass("has-success")},
                        unhighlight:function(t,n,a){$(t).parents(".form-group").addClass("has-success").removeClass("has-error")},

        });
</script>
