<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BemMaterial extends Model
{
    use HasFactory;

    protected $table = 'bens_materiais';
    /**
    * The attributes that are mass assignable.
    *
    * @var array
    */
   protected $fillable = [
       'igrejas_id','tipos_bens_materiais_id','formas_aquisicao_bens_id','membros_id',
       'nome','estado','referencia','valor','data'
    ];


    public function igreja()
    {
        return $this->belongsTo('App\Models\Igreja','igrejas_id','id');
    }

    public function tipos_bens_materiais()
    {
        return $this->belongsTo('App\Models\TipoBemMaterial');
    }

    public function formas_aquisicao_bens()
    {
        return $this->belongsTo('App\Models\FormaAquisicaoBem','formas_aquisicao_bens_id','id');
    }

    public function membro()
    {
        return $this->belongsTo('App\Models\Membro','membros_id','id');
    }

    public function depreciacao_bens_materiais()
    {
         return $this->hasMany('App\Models\DepreciacaoBemMaterial');
    }

}
