<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePaisRequest extends FormRequest
{
   /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (auth()->user()->role_id==1 || auth()->user()->role_id==2) {
            return true;
                                                         }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id' => [
                'required',
                 Rule::unique('pais')->where(function($query){
                     $query->where('pais_id',$this->pais_id)
                           ;
                 })
                ],
            //'ano_id'  => 'required',
           // 'conta_bancaria_id'  => 'required',
           // 'valor'  => 'required|numeric|digits_between:0,5000'
        ];
    }


    public function messages(){
        return [
            'pais_id.unique'               => 'O pais seleccionado já está registado.',
            //'ano_id.required'                  => 'O campo ano lectivo é de preencimento obrigatório.',
           // 'conta_bancaria_id.required'       => 'O campo conta bancária é de preenchimento obrigatório.',
            ];
                             }
}
