<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class StoreIgrejaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (auth()->user()->role_id==1 || auth()->user()->role_id==2) {
            return true;
        }

    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email' => 'required|unique:igrejas|email',
            'categoria'   => 'required|min:2',
            'descricao'    => 'required|min:4',
            'telefone'  => 'required|numeric|digits_between:9,12'
        ];
    }

    public function messages(){
        return [
            'email.email'               => 'O email seleccionado deve ser do tipo email.',
            'email.unique'            => 'O email seleccionado já está a ser utilizado.',
            'descricao.required'      => 'O campo Descricao é de preencimento obrigatório.',
            'telefone.required'       => 'O campo Telefone é de preenchimento obrigatório.',
            ];
    }
}
