<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class StoreEventoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (auth()->user()->role_id==1 || auth()->user()->role_id==2) {
            return true;
        }

    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'titulo' => 'required',
            'pastor'   => 'required|min:2',
            'horario'    => 'required|min:1|max:100'
        ];
    }

    public function messages(){
        return [

            'titulo.unique'            => 'O titulo seleccionado já está a ser utilizado.',
            'pastor.required'      => 'O campo pastor é de preencimento obrigatório.',

            ];
    }
}
