<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\FormaPagamento;
use Livewire\WithPagination;
use Illuminate\Validation\Rule;

class formasPagamentos extends Component
{

    use WithPagination;
    public $formasPagamentos, $nome, $descricao, $formaPagamento_id,$prompt;
    public $updateMode = false;

    protected $listeners = [
        'refresh'
    ];

    protected $rules = [
        'nome' => 'required|unique:App\Models\FormaPagamento,nome',
        'descricao' => 'required'
    ];


    public function render()
    {
        //dd('vv');
        return view('livewire.formas-pagamentos',[
            'v_formasPagamentos' =>  FormaPagamento::paginate(100),
        ]);

    }

    private function resetInputFields(){
        $this->nome = '';
        $this->descricao = '';

    }

    public function refresh(){

        $this->prompt = 'The prompt done.';

    }

    /**
     * store
     *
     * @return void
     */
    public function store()
    {
        //dd('vv');
        // Validate Form Request
        $this->validate();


       // dd('vv');

        FormaPagamento::create([
            'nome'=>$this->nome,
            'descricao'=>$this->descricao
        ]);

        session()->flash('message', '<i class="fa fa-check-circle"></i> Forma De Pagamento criada!.');

        $this->resetInputFields();
        $this->dispatchBrowserEvent('close-modal');
        //$this->emit('formaPagamentoStore'); // Close model to using to jquery

    }

    public function edit($id)
    {
        $ID = decrypt($id);
        $formaPagamento = FormaPagamento::findOrFail($ID);

        $this->formaPagamento_id = $ID;
        $this->nome = $formaPagamento->nome;
        $this->descricao = $formaPagamento->descricao;

        $this->updateMode = true;
    }

    public function cancel()
    {
        $this->updateMode = false;
        $this->resetInputFields();
    }

    public function update()
    {
        $validatedDate = $this->validate([
            'nome' => 'required|unique:formas_pagamentos,nome,'.$this->formaPagamento_id,
            'descricao' => 'required'
        ]);

        if ($this->formaPagamento_id) {
            $formaPagamento = FormaPagamento::find($this->formaPagamento_id);
            $formaPagamento->update([
                'nome' => $this->nome,
                'descricao' => $this->descricao
            ]);
            $this->updateMode = false;
            session()->flash('message', '<i class="fa fa-check-circle"></i> Forma Pagamento actualizada!.');
            $this->resetInputFields();

        }
    }

    public function delete($id)
    {
        $ID = decrypt($id);


        if($ID){
            FormaPagamento::where('id',$ID)->delete();
            session()->flash('message', 'Forma Pagamento eliminada!.');
        }
    }

    public function limpaCampos(){
        $this->resetInputFields();
    }
}
