<?php

namespace App\Http\Controllers;


use App\Models\Saida;
use App\Models\TipoSaida;
use App\Models\FormaPagamento;
use App\Models\Caixa;
use App\Models\Membro;
use DB;
use App\Http\Requests\StoreSaidaRequest;
use App\Http\Requests\UpdateSaidaRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class SaidaController extends Controller
{
    //
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //die('verificar');
        $saidas = Saida::latest()->paginate(150);
        $tipossaidas = TipoSaida::all();
        $formaspagamentos = FormaPagamento::all();
        $membros = Membro::all();

        return view('saida.index',compact('saidas','tipossaidas','formaspagamentos','membros'))
            ->with('i', (request()->input('page', 1) - 1) * 150);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //die($eventos );
        $saidas = Saida::all();
        $tipossaidas = TipoSaida::all();
        $formaspagamentos = FormaPagamento::all();
        $membros = Membro::all();
        $caixas = Caixa::all();

        return view('saida.create',['saidas' => $saidas, 'tipossaidas' => $tipossaidas, 'formaspagamentos' => $formaspagamentos,'caixas' => $caixas,'membros' => $membros]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreSaidaRequest $request)
    {


        //dd($qtd_total_part);

        if (Gate::allows('isGestor') || Gate::allows('isSuperadmin') || Gate::allows('isFinanceiro') ) {

            DB::beginTransaction();

            //movimentando a caixa
            $caixas = DB::table('caixas')->where('status', '=', 1)->get();
           // $saldoAnterior = $caixa['saldoActual'];

           foreach ($caixas as $caixa) {
                        //dd($caixa->saldoActual);

                //Mantendo o aldo anterior
                $saldoAnt = $caixa->saldoActual;
                //Actualizar o saldo actual
                $saldoActual =$caixa->saldoActual;
                //Validar se o valor da saida esta diponivel na caixa
                $result=$request->valor < ($caixa->saldoActual - $request->valor);
                //dd($result);
                if($result == false){

                    DB::rollBack();

                    DB::beginTransaction(false);
                      return view('errors.messageSaida');
                }else{
                    //Actualizando o saldo actual após a saida ter todas condições
                    $saldoActual = ($caixa->saldoActual - $request->valor);
                    DB::table('caixas')->where('status', '=', 1)->update(['saldoAnt'=>$saldoAnt,'saldoActual'=>$saldoActual]);

                    Saida::create(
                    ['valor' => $request->valor,
                    'descricao'   =>  $request->descricao,
                    'data_saida'   => $request->data_saida,
                    'tipos_saidas_id'   => $request->tipos_saidas_id,
                    'formas_pagamentos_id'   => $request->formas_pagamentos_id,
                    'membros_id'   => $request->membros_id
                    ]);

            //Entranda::create($request->all(),$qtd_total_part);
            DB::commit();
            return redirect()->route('saidas.index')
            ->with('mensagem','Saida registado com sucesso');
        }






}                                }
            else{
                DB::rollBack();

                DB::beginTransaction(false);
                  return view('errors.message');
                }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Saida  $saida
     * @return \Illuminate\Http\Response
     */
    public function show(Request  $request,$id)
    {
        //dd($evento);
        $ID = decrypt($id);
        $saida = Saida::findOrFail($ID);

        $tipossaidas = TipoSaida::all();
        $formaspagamentos = FormaPagamento::all();
        $caixas = Caixa::all();
        $membros = Membro::all();

        return view('saida.show',compact('saida','tipossaidas','formaspagamentos','caixas','membros'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Saida $saida
     * @return \Illuminate\Http\Response
     */
    public function edit(Request  $request,$id)
    {
        $ID = decrypt($id);
        $saida = Saida::findOrFail($ID);

        $tipossaidas = TipoSaida::all();
        $formaspagamentos = FormaPagamento::all();
        $caixas = Caixa::all();
        $membros = Membro::all();

        return view('saida.create',['saida' => $saida, 'tipossaidas' => $tipossaidas, 'formaspagamentos' => $formaspagamentos,'caixas' => $caixas,'membros' => $membros]);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Saida  $saida
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateSaidaRequest $request,  $id)
    {
        $ID = decrypt($id);
        $saida = Saida::findOrFail($ID);
        //die($request->all());
        if (Gate::allows('isSuperadmin')  ) {
            $saida->update($request->all());

            return redirect()->route('saidas.index')
                            ->with('mensagem','Saida actualizado com sucesso');
                                              }
                        else{
                            return view('errors.message');
                            }
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Saida  $saida
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request  $request,$id)
    {
        $ID = decrypt($id);
        $saida = Saida::findOrFail($ID);

        if (Gate::allows('isSuperadmin')) {
            $saida->delete();

            return redirect()->route('saidas.index')
                            ->with('mensagem','Saida eliminado com sucesso');

                        }
                        else{
                            return view('errors.message', ['mensagem' => 'Não tem autorização para executar esta acção']);
                            }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function exploracaoAjax()
    {

            $array = array();

            $saidas = Saida::all();

            foreach ($saidas as $saida) {

               // $user = $entrada->user;
                $tmp_array = array(
                    'id' => $saida->id,

                    'tipo_saida' => $saida->tipos_saidas->nome,
                    //'membro' => $entrada->membros->nome,
                    'forma_pagamento' => $saida->formas_pagamentos->nome,
                    'descricao' => $saida->descricao,
                    'valor' => $saida->valor,
                    'data_saida' => $saida->data_saida,



                );

                array_push($array, $tmp_array);
            }

            return json_encode($array);

    }

    public function exploracao()
    {
        $membros = Membro::orderBy('id', 'asc')->get();
        return view('saida.exploracao',compact('membros'));
    }




}
