<?php

namespace App\Http\Controllers;

use PDF;
use App\Models\Membro;
use App\Models\Evento;

use Illuminate\Http\Request;

class PDFController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function membrosPDF()
    {

        $data = Membro::all();

        $pdf = PDF::loadView('exploracao.pdf.membrosPdf',compact('data'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setPaper('A4', 'landscape');
        return $pdf->download('TodosMembros.pdf');

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function eventosPDF()
    {

        $data = Evento::all();

        $pdf = PDF::loadView('exploracao.pdf.eventosPdf',compact('data'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setPaper('A4', 'landscape');
        return $pdf->download('TodosEventos.pdf');

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function eventoPDF($id)
    {


        $evento = Evento::find($id);
        //dd($data);
        $pdf = PDF::loadView('exploracao.pdf.eventoPdf',compact('evento'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setPaper('A4', 'portrait');
        return $pdf->download('DetalheEvento.pdf');

    }
}
