<?php

namespace App\Http\Controllers;

use App\Models\Evento;
use App\Models\Igreja;
use App\Models\Membro;
use App\Models\TipoEvento;
use Illuminate\Support\Facades\Gate;
use App\Http\Requests\StoreEventoRequest;
use App\Http\Requests\UpdateEventoRequest;
use Illuminate\Http\Request;

class EventoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //die('verificar');
        $data = Evento::latest()->paginate(150);
        //dd($data);

        return view('evento.index',compact('data'))
            ->with('i', (request()->input('page', 1) - 1) * 150);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //die($eventos );
        $eventos = Evento::all();
        $igrejas = Igreja::all();
        $tiposeventos = TipoEvento::all();

        return view('evento.create',['eventos' => $eventos, 'igrejas' => $igrejas, 'tiposeventos' => $tiposeventos]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreEventoRequest $request)
    {

        $qtd_total_part=$request->qtd_adulto + $request->qtd_crianca + $request->qtd_conversoes + $request->qtd_visita + $request->qtd_pastor_pres + $request->qtd_batizados;
        $total_ofertas_gerais=$request->total_dizimo+$request->total_arrecadado+$request->total_ofertas_esp;
        //dd($qtd_total_part);

        if (Gate::allows('isGestor') || Gate::allows('isSuperadmin') ) {

            Evento::create(
            ['titulo' => $request->titulo,
            'pastor'   =>  $request->pastor,
            'data_culto'   => $request->data_culto,
            'horario'   => $request->horario,
            'qtd_adulto'   => $request->qtd_adulto,
            'qtd_crianca'   => $request->qtd_crianca,
            'qtd_conversoes'   => $request->qtd_conversoes,
            'qtd_visita'   => $request->qtd_visita,
            'qtd_pastor_pres'   => $request->qtd_pastor_pres,
            'qtd_batizados'   => $request->qtd_batizados,
            'qtd_total_part'   => $qtd_total_part,
            'total_dizimo'   => $request->total_dizimo,
            'total_arrecadado'   => $request->total_arrecadado,
            'total_ofertas_esp'   => $request->total_ofertas_esp,
            'total_ofertas_gerais'   => $total_ofertas_gerais,
            'dizimista'   => $request->dizimista,
            'outros'   => $request->outros,
            'igreja_id'   => $request->igreja_id,
            'tipos_eventos_id'   => $request->tipos_eventos_id
            ]);

            //Evento::create($request->all(),$qtd_total_part);

            return redirect()->route('eventos.index')
            ->with('mensagem','Evento registado com sucesso');
                                            }
            else{
                  return view('errors.message');
                }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Evento  $evento
     * @return \Illuminate\Http\Response
     */
    public function show(Request  $request,$id)
    {
        //dd($evento);
        $ID = decrypt($id);
        $evento = Evento::findOrFail($ID);

        return view('evento.show',compact('evento'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Evento  $evento
     * @return \Illuminate\Http\Response
     */
    public function edit(Request  $request,$id)
    {
        $ID = decrypt($id);
        $evento = Evento::findOrFail($ID);

        $igrejas = Igreja::all();
        $tiposeventos = TipoEvento::all();

        return view('evento.create',compact('evento','igrejas','tiposeventos'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Evento  $evento
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateEventoRequest $request, $id)
    {
        $ID = decrypt($id);
        $evento = Evento::findOrFail($ID);

        //die($request->all());
        if (Gate::allows('isSuperadmin') || Gate::allows('isGestor') ) {
            $evento->update($request->all());

            return redirect()->route('eventos.index')
                            ->with('mensagem','Evento actualizado com sucesso');
                                              }
                        else{
                            return view('errors.message');
                            }
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Evento  $evento
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request  $request,$id)
    {

        $ID = decrypt($id);
        $evento = Evento::findOrFail($ID);

        if (Gate::allows('isSuperadmin')) {
            $evento->delete();

            return redirect()->route('eventos.index')
                            ->with('mensagem','Evento eliminado com sucesso');

                        }
                        else{
                            return view('errors.message', ['mensagem' => 'Não tem autorização para executar esta acção']);
                            }
    }

      /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function exploracaoAjax()
    {

            $array = array();

            $eventos = Evento::all();

            foreach ($eventos as $evento) {

               // $user = $entrada->user;
                $tmp_array = array(
                    'id' => $evento->id,

                    'titulo' => $evento->titulo,
                    'pastor'   =>  $evento->pastor,
                    'data_culto'   => $evento->data_culto,
                    'horario'   => $evento->horario,
                    'qtd_adulto'   => $evento->qtd_adulto,
                    'qtd_crianca'   => $evento->qtd_crianca,
                    'qtd_conversoes'   => $evento->qtd_conversoes,
                    'qtd_visita'   => $evento->qtd_visita,
                    'qtd_pastor_pres'   => $evento->qtd_pastor_pres,
                    'qtd_batizados'   => $evento->qtd_batizados,
                    //'qtd_total_part'   => $evento->qtd_total_part,
                    'total_dizimo'   => $evento->total_dizimo,
                    'total_arrecadado'   => $evento->total_arrecadado,
                    'total_ofertas_esp'   => $evento->total_ofertas_esp,
                    //'total_ofertas_gerais'   => $evento->total_ofertas_gerais,
                    'dizimista'   => $evento->dizimista,
                    'tipo_evento' => $evento->tipos_eventos->nome,
                    'igreja' => $evento->igreja->nome,




                );

                array_push($array, $tmp_array);
            }

            return json_encode($array);

    }

    public function exploracao()
    {
        $membros = Membro::orderBy('id', 'asc')->get();
        return view('evento.exploracao',compact('membros'));
    }






}
