<?php

namespace App\Http\Controllers;


use App\Models\Caixa;
use App\Models\TipoCaixa;
use App\Models\FormaPagamento;
use App\Models\Membro;
use DB;
use App\Http\Requests\StoreCaixaRequest;
use App\Http\Requests\UpdateCaixaRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class CaixaController extends Controller
{
    //
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //die('verificar');
        $caixas = Caixa::latest()->paginate(150);



        return view('caixa.index',compact('caixas'))
            ->with('i', (request()->input('page', 1) - 1) * 150);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //die($eventos );
        $caixas = Caixa::all();


        return view('caixa.create',['caixas' => $caixas]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreCaixaRequest $request)
    {


        //dd($qtd_total_part);

        if (Gate::allows('isGestor') || Gate::allows('isSuperadmin') ) {

            DB::beginTransaction();

            Caixa::create($request->all());


            DB::commit();
            return redirect()->route('caixas.index')
            ->with('mensagem','Caixa registado com sucesso');
                                            }
            else{
                  return view('errors.message');
                }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Caixa  $caixa
     * @return \Illuminate\Http\Response
     */
    public function show(Request  $request,$id)
    {
        //dd($evento);

        $ID = decrypt($id);
        $caixa = Caixa::findOrFail($ID);
        //$caixas = Caixa::all();

        return view('caixa.show',compact('caixa'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Caixa $caixa
     * @return \Illuminate\Http\Response
     */
    public function edit(Request  $request,$id)
    {
        //$caixas = Caixa::all();
        $ID = decrypt($id);
        $caixas = Caixa::findOrFail($ID);

        return view('caixa.create',['caixas' => $caixas]);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Caixa  $caixa
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateCaixaRequest $request, $id)
    {

        $ID = decrypt($id);
        $caixa = Caixa::findOrFail($ID);
        //die($request->all());
        if (Gate::allows('isSuperadmin')  ) {
            $caixa->update($request->all());

            return redirect()->route('caixas.index')
                            ->with('mensagem','Caixa actualizado com sucesso');
                                              }
                        else{
                            return view('errors.message');
                            }
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Caixa  $caixa
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request  $request,$id)
    {
        $ID = decrypt($id);
        $caixa = Caixa::findOrFail($ID);
        if (Gate::allows('isSuperadmin')) {
            $caixa->delete();

            return redirect()->route('caixas.index')
                            ->with('mensagem','Caixa eliminado com sucesso');

                        }
                        else{
                            return view('errors.message', ['mensagem' => 'Não tem autorização para executar esta acção']);
                            }
    }


}
